/* based upon				*/
/*	cpmio.h	1.4	83/05/13	*/

#ifndef CPMIO_H
#define CPMIO_H

#include <stdio.h>
#include "cpmfio.h"

/* debugging routines	*/

#define M(f)		fprintf(stderr,f); fflush(stderr);
#define M1(f,a)		fprintf(stderr,f,a); fflush(stderr);
#define M2(f,a,b)	fprintf(stderr,f,a,b); fflush(stderr);
#define M3(f,a,b,c)	fprintf(stderr,f,a,b,c); fflush(stderr);
#define M4(f,a,b,c,d)	fprintf(stderr,f,a,b,c,d); fflush(stderr);

/* number of bits per integer on this particular machine */

#define INTSIZE 	(sizeof(int)*8)

#define TRUE	1
#define FALSE	0

struct directory {
	char status;		/* status of this entry; equals 0xe5 if */
				/* free to use, otherwise contains the */
				/* user number (owner) (0 - 15)	*/
	char name[8];		/* File name, padded with blanks */
	char ext[3];		/* file name extension, padded with blanks */
	char extno;		/* extent number */
	char notused[2];	/* unused */
	char blkcnt;		/* record count, number of 128 byte records */
				/* in this extent */
	char pointers[16];	/* pointers to the individual blocks */
};

#define CPMSECSIZ 128		/* number of bytes per sector in CP/M terms */

#define blockno(f,i) (f->cpmfs->use16bitptrs?					\
		    (0xff & (int)f->c_dirp->pointers[2*(i)]) +	\
		    ((0xff & (int)f->c_dirp->pointers[2*(i)+1]) << 8): \
		    0xff & (int)f->c_dirp->pointers[i])

/* These two routines interface to a "standard" floppy sector reading
   and writing routine.  Note that the arguments to both are:

       (void *) the rock that is the device (struct floppy *) for eg
          (int) side
          (int) track
          (int) sector
       (char *) buffer for the data
*/

typedef int (*cpmreadfn)(void *,int,int,int,char*);
typedef int (*cpmwritefn)(void *,int,int,int,char*);

typedef void *cpmdevice;

struct cpmfs {
    struct directory	*dirbuf;

    C_FILE	*c_iob;		/* open files buffer	*/
    int		numfiles;	/* number of files avail*/

    cpmdevice	device;
    cpmreadfn	preadsec;
    cpmwritefn	pwritesec;
    int	startsec;	/* 0 or 1 for the phys start sector	*/

    int	blksiz;		/* size of an allocation block		*/
    int	tracks;		/* number of tracks			*/
    int	maxdir;		/* number of directory entries		*/
			
    int	seclth;		/* length of a sector			*/
    int	sectrk;		/* sectors per track, in CPM terms	*/
    int	skew;		/* sector skew				*/
    int	restrk;		/* reserved tracks (for system) 	*/

    int	*bitmap;	/* allocation block bitmap		*/
    int *skewtab;	/* skew mapping table for sectors	*/
    int	bm_size;
    int	use16bitptrs;
};

#endif
